package ie.imobile.extremepush.ui;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;

import ie.imobile.extremepush.NotificationOnClickHandler;
import ie.imobile.extremepush.google.XPFirebaseMessagingService;
import ie.imobile.extremepush.util.LogEventsUtils;

/**
 * Created by mbreen on 28/10/2016.
 */

public class OnclickPushActivity extends Activity {


    private static String TAG = OnclickPushActivity.class.getSimpleName();

    @Override
    public void onCreate(Bundle b) {
        super.onCreate(b);
        Intent i;
        try {
            if (getIntent() != null) {
                i = getIntent();

                NotificationOnClickHandler nc = new NotificationOnClickHandler();
                Intent mIntent = nc.handleNotificationClick(this, i);
                if(mIntent != null) {
                    if(isTaskRoot())
                        mIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_SINGLE_TOP);
                    else
                        mIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
                    startActivity(mIntent);
                } else {
                    PackageManager pm = this.getPackageManager();
                    i = pm.getLaunchIntentForPackage(this.getPackageName());
                    startActivity(i);
                }
            }
//            Intent closeNotificationTray = new Intent(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
//            this.sendBroadcast(closeNotificationTray);
            if (android.os.Build.VERSION.SDK_INT >= 21 && isTaskRoot()) {
                finishAndRemoveTask();
            } else {
                finish();
            }

        } catch (Exception e) {
            LogEventsUtils.sendLogTextMessage(TAG, "onCLickPushActivity null intent");
            finish();
        }
    }
}

